/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp;

import com.ibm.hsc.fsp.AsyncEventHandler;
import java.util.Vector;

public class FspSvrAsyncSubscription {
    private int mEventType = -1;
    private Vector mEventData = new Vector();
    private int mTimeout = 6000000;
    private int mWaitType;
    private boolean mInWaiting = false;
    private AsyncEventHandler mAsyncHandler = null;
    private boolean mClose = false;
    private String mCreationThread = null;
    private long mCreationTime = 0L;
    private Thread mThread = null;
    public static final int WAIT_ONLY_ONCE = 0;
    public static final int WAIT_UNTIL_UNSUBSCRIBE = 1;
    public static final int SVR_CEC_STATE_CHANGE_EVT = 0;
    public static final int ON_DEMAND_KEY_PROCESSING_EVT = 1;

    public FspSvrAsyncSubscription(AsyncEventHandler asyncEventHandler, int n, int n2, int n3) {
        this.mAsyncHandler = asyncEventHandler;
        this.mEventType = n;
        this.mWaitType = n2;
        this.mTimeout = n3;
        this.mClose = false;
        this.mCreationThread = Thread.currentThread().getName();
        this.mCreationTime = System.currentTimeMillis();
        this.mAsyncHandler.subscribe(this);
    }

    public int getEventType() {
        return this.mEventType;
    }

    public String tosString() {
        String string = "FspSvrAsyncSubscription(EventType: " + this.mEventType + " Timeout: " + this.mTimeout + " WaitTtype: " + this.mWaitType + " closed: " + this.mClose + " inWaitig" + this.mInWaiting + " evtDataNum: " + this.mEventData.size() + " creationThread: " + this.mCreationThread + " creationTime: " + this.mCreationTime + ")";
        return string;
    }

    public synchronized byte[] getNextEvent() {
        if (this.mClose) {
            return null;
        }
        this.mThread = Thread.currentThread();
        if (this.mEventData.size() < 1) {
            this.mInWaiting = true;
            try {
                if (this.mTimeout == -1) {
                    this.wait();
                } else {
                    this.wait(this.mTimeout);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.mInWaiting = false;
        this.mThread = null;
        if (this.mWaitType == 0) {
            this.mAsyncHandler.unsubscribe(this);
            this.mClose = true;
        }
        if (this.mEventData.size() > 0) {
            byte[] byArray = (byte[])this.mEventData.remove(0);
            return byArray;
        }
        return null;
    }

    public synchronized void addEvent(byte[] byArray) {
        this.mEventData.addElement(byArray);
        if (this.mInWaiting) {
            try {
                this.notify();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void close() {
        if (!this.mClose) {
            this.mAsyncHandler.unsubscribe(this);
            if (this.mInWaiting && this.mThread != null) {
                this.mThread.interrupt();
            }
            this.mClose = true;
        }
    }
}

